import { world, system } from "@minecraft/server"
const ENTITY = "sf_nba:peafowl"
const TAME_CHANCE = 3
const BUFFS = [
	{ name: "strength", duration: 1200, amplifier: 2 }
]
const DANCING_PEAFOWLS = []
function randomInt(min, max) {
	return Math.floor(Math.random() * (max - min + 1)) + min
}
function getNearbyPeafowls(player, all = false) {
	let peafowls = []
	if (all) {
		for (const dimension of ["overworld", "nether", "the_end"]) {
			const entities = world.getDimension(dimension).getEntities({
				type: ENTITY
			})
			for (const entity of entities) peafowls.push(entity)
		}
		return peafowls
	}
	peafowls = player.dimension.getEntities({
		type: ENTITY,
		location: player.location,
		maxDistance: 6
	})
	return peafowls
}
function tamePeafowl(player) {
	const peafowls = getNearbyPeafowls(player)
	if (!peafowls.length) return
	for (const peafowl of peafowls) {
		if (!peafowl.isValid()) continue
		if (peafowl.targetId != player.id) continue
		const tameable = peafowl.getComponent("minecraft:tameable")
		if (!peafowl.getProperty("sf_nba:is_dancing") || !tameable) continue
		if (TAME_CHANCE < randomInt(1, 100)) continue
		tameable.tame(player)
		peafowl.setProperty("sf_nba:is_dancing", false)
		peafowl.targetId = undefined
	}
}
function stopDanceRitual(player) {
	const peafowls = getNearbyPeafowls(player, true)
	if (!peafowls.length) return
	for (const peafowl of peafowls) {
		if (!peafowl.isValid()) continue
		peafowl.triggerEvent("sf_nba:stop_dancing")
		peafowl.targetId = undefined
		player.dancingPeafowls = []
	}
}
class StateMachines {
	static #run(actor, controller) {
		const controllerId = `sf_nba_${controller.name}`
		const states = controller.states
		if (!actor[controllerId]) {
			actor[controllerId] = {
				currentState: Object.keys(states)[0],
				isRunning: false
			}
		}
		const actorState = actor[controllerId]
		const currentState = states[actorState.currentState]
		if (!actorState.isRunning) {
			if (typeof currentState.onEntry == "function") currentState.onEntry()
			actorState.isRunning = true
			return
		}
		if (!currentState.transitions || !currentState.transitions.length) return
		for (const transition of currentState.transitions) {
			if (Object.values(transition).includes(true)) {
				const nextState = Object.keys(transition)
				if (typeof currentState.onExit == "function") currentState.onExit()
				if (typeof states[nextState].onEntry == "function") states[nextState].onEntry()
				actorState.currentState = nextState
				return
			}
		}
	}
	static add(controller) {
		system.runInterval(() => {
			for (const player of world.getPlayers()) {
				this.#run(player, controller(player))
			}
		}, 1)
	}
}
StateMachines.add(actor => {
	const data = {
		name: "peacock",
		states: {
			"default": {
				onEntry: () => {
					actor.dancingPeafowls = []
					actor.sneakTick = 0
					actor.standTick = 0
					actor.stopTick = 0
					const peafowls = getNearbyPeafowls(actor, true)
					for (const peafowl of peafowls) {
						if (peafowl.targetId == actor.id)
						peafowl.targetId = undefined
						peafowl.triggerEvent("sf_nba:stop_dancing")
					}
				},
				transitions: [
					{ "sneak": actor.isSneaking }
				]
			},
			"sneak": {
				onEntry: () => {
					actor.standTick = 0
					actor.sneakTick++
					const peafowls = getNearbyPeafowls(actor)
					for (const peafowl of peafowls) {
						if (peafowl.getProperty("sf_nba:is_dancing")) continue
						peafowl.targetId = actor.id
						peafowl.triggerEvent("sf_nba:start_dancing")
						actor.dancingPeafowls.push(peafowl)
					}
					for (const peafowl in actor.dancingPeafowls) {
						if (peafowls.includes(actor.dancingPeafowls[peafowl])) continue
						actor.dancingPeafowls[peafowl].targetId = undefined
						actor.dancingPeafowls[peafowl].triggerEvent("sf_nba:stop_dancing")
						actor.dancingPeafowls.splice(peafowl, 1)
					}
				},
				transitions: [
					{ "stand": !actor.isSneaking && actor.sneakTick < 40 },
					{ "sneak": actor.isSneaking && actor.sneakTick < 40 },
					{ "stop": actor.sneakTick >= 40 }
				]
			},
			"stand": {
				onEntry: () => {
					actor.sneakTick = 0
					if (actor.standTick <= 10) tamePeafowl(actor)
					actor.standTick++
				},
				transitions: [
					{ "sneak": actor.isSneaking && actor.standTick < 40 },
					{ "stand": !actor.isSneaking && actor.standTick < 40 },
					{ "stop": actor.standTick >= 40 }
				]
			},
			"stop": {
				onEntry: () => {
					if (!actor.stopTick) stopDanceRitual(actor)
				},
				transitions: [
					{ "default": true }
				]
			}
		}
	}
	return data
})
StateMachines.add(actor => {
	return {
		name: "peacloak",
		states: {
			"default": {
				onEntry: () => {
					actor.runCommand("effect @s slow_falling 0")
				},
				transitions: [
					{ "equipped": actor.getComponent("equippable")?.getEquipment("Chest")?.typeId == "sf_nba:peacloak" && actor.isSneaking && !actor.isOnGround }
				]
			},
			"equipped": {
				onEntry: () => {
					actor.runCommand("effect @s slow_falling infinite 9 true")
				},
				transitions: [
					{ "default": actor.getComponent("equippable")?.getEquipment("Chest")?.typeId != "sf_nba:peacloak" || !actor.isSneaking || actor.isOnGround }
				]
			}
		}
	}
})
system.afterEvents.scriptEventReceive.subscribe(e => {
	if (e.id == "sf_nba:peafowl_unfurl") {
		for (const player of world.getPlayers()) {
			const tameId = e.sourceEntity.getDynamicProperty("sf_nba:tame_id")
			if (tameId != player.id) continue
			for (const buff of BUFFS) {
				player.addEffect(buff.name, buff.duration, { amplifier: buff.amplifier, showParticles: false })
			}
		}
	}
})
world.afterEvents.entityLoad.subscribe(e => {
	if (e.entity.typeId != ENTITY) return
	e.entity.triggerEvent("sf_nba:stop_dancing")
	e.entity.targetId = undefined
})